drop schema if exists xtest;
create schema xtest;
use xtest;

#
# INTEGER TYPES
#

CREATE TABLE t_tinyint (c1  TINYINT, c2 TINYINT UNSIGNED);
INSERT INTO t_tinyint VALUES (-128, 0);
INSERT INTO t_tinyint VALUES (-1, 1);
INSERT INTO t_tinyint VALUES (0, 127);
INSERT INTO t_tinyint VALUES (1, 200);
INSERT INTO t_tinyint VALUES (127, 255);
INSERT INTO t_tinyint VALUES (NULL, NULL);

CREATE TABLE t_smallint (c1  SMALLINT, c2 SMALLINT UNSIGNED);
INSERT INTO t_smallint VALUES (-32768, 0);
INSERT INTO t_smallint VALUES (-1, 1);
INSERT INTO t_smallint VALUES (0, 32767);
INSERT INTO t_smallint VALUES (1, 65534);
INSERT INTO t_smallint VALUES (32767, 65535);
INSERT INTO t_smallint VALUES (NULL, NULL);

CREATE TABLE t_mediumint (c1  MEDIUMINT, c2 MEDIUMINT UNSIGNED);
INSERT INTO t_mediumint VALUES (-8388608, 0);
INSERT INTO t_mediumint VALUES (-1, 1);
INSERT INTO t_mediumint VALUES (0, 8388607);
INSERT INTO t_mediumint VALUES (1, 16777214);
INSERT INTO t_mediumint VALUES (8388607, 16777215);
INSERT INTO t_mediumint VALUES (NULL, NULL);

CREATE TABLE t_int (c1  INT, c2 INT UNSIGNED);
INSERT INTO t_int VALUES (-2147483648, 0);
INSERT INTO t_int VALUES (-1, 1);
INSERT INTO t_int VALUES (0, 2147483647);
INSERT INTO t_int VALUES (1, 4294967294);
INSERT INTO t_int VALUES (2147483647, 4294967295);
INSERT INTO t_int VALUES (NULL, NULL);

CREATE TABLE t_integer (c1  INTEGER, c2 INTEGER UNSIGNED);
INSERT INTO t_integer VALUES (-2147483648, 0);
INSERT INTO t_integer VALUES (-1, 1);
INSERT INTO t_integer VALUES (0, 2147483647);
INSERT INTO t_integer VALUES (1, 4294967294);
INSERT INTO t_integer VALUES (2147483647, 4294967295);
INSERT INTO t_integer VALUES (NULL, NULL);

CREATE TABLE t_bigint (c1  BIGINT, c2 BIGINT UNSIGNED);
INSERT INTO t_bigint VALUES (-9223372036854775808, 0);
INSERT INTO t_bigint VALUES (-1, 1);
INSERT INTO t_bigint VALUES (0, 9223372036854775807);
INSERT INTO t_bigint VALUES (1, 18446744073709551614);
INSERT INTO t_bigint VALUES (9223372036854775807, 18446744073709551615);
INSERT INTO t_bigint VALUES (NULL, NULL);

#
# FIXED POINT TYPES
#

CREATE TABLE t_decimal1 (c1  DECIMAL(2,1),  c2 DECIMAL(2,1) UNSIGNED);
INSERT INTO t_decimal1 VALUES (-1.1, 0.0);
INSERT INTO t_decimal1 VALUES (-9.9, 9.8);
INSERT INTO t_decimal1 VALUES (9.9, 9.9);
INSERT INTO t_decimal1 VALUES (NULL, NULL);

CREATE TABLE t_decimal2 (c1  DECIMAL(64,30),  c2 DECIMAL(64,30) UNSIGNED);
INSERT INTO t_decimal2 VALUES (-1234567890123456789012345678901234.567890123456789012345678901234, 1234567890123456789012345678901234.567890123456789012345678901234);
INSERT INTO t_decimal2 VALUES (9234567890123456789012345678901234.567890123456789012345678901234, 9234567890123456789012345678901234.567890123456789012345678901234);
INSERT INTO t_decimal2 VALUES (0, 0);

CREATE TABLE t_decimal3 (c1  DECIMAL(2,0),  c2 DECIMAL(2,0) UNSIGNED);
INSERT INTO t_decimal3 VALUES (-1, 1);
INSERT INTO t_decimal3 VALUES (-5, 5);
INSERT INTO t_decimal3 VALUES (NULL, NULL);

CREATE TABLE t_numeric1 (c1  NUMERIC(2,1),  c2 NUMERIC(2,1) UNSIGNED);
INSERT INTO t_numeric1 VALUES (-1.1, 0.0);
INSERT INTO t_numeric1 VALUES (-9.9, 9.8);
INSERT INTO t_numeric1 VALUES (9.9, 9.9);

CREATE TABLE t_numeric2 (c1  NUMERIC(64,30),  c2 NUMERIC(64,30) UNSIGNED);
INSERT INTO t_numeric2 VALUES (-1234567890123456789012345678901234.567890123456789012345678901234, 1234567890123456789012345678901234.567890123456789012345678901234);
INSERT INTO t_numeric2 VALUES (9234567890123456789012345678901234.567890123456789012345678901234, 9234567890123456789012345678901234.567890123456789012345678901234);
INSERT INTO t_numeric2 VALUES (0, 0);

#
# FLOATING POINT TYPES
#

CREATE TABLE t_real (c1  REAL,  c2 REAL UNSIGNED);
INSERT INTO t_real VALUES (-1220.001, 0);
INSERT INTO t_real VALUES (-1.01, 1.201);
INSERT INTO t_real VALUES (1235.67, 11235.67);

CREATE TABLE t_float (c1  FLOAT,  c2 FLOAT UNSIGNED);
INSERT INTO t_float VALUES (-1220223.00221, 0.0001);
INSERT INTO t_float VALUES (-1.02323, 1.2333);
INSERT INTO t_float VALUES (123522.67, 112352.67);
INSERT INTO t_float VALUES (NULL, NULL);

CREATE TABLE t_double (c1  DOUBLE,  c2 DOUBLE UNSIGNED);
INSERT INTO t_double VALUES (-122022323.0230221, 2320.0012301);
INSERT INTO t_double VALUES (-1.232023231, 1231231231.23331231);
INSERT INTO t_double VALUES (1235212322.6123123, 11235212312322.671);
INSERT INTO t_double VALUES (NULL, NULL);

#
# DATE
#

SET @SAVE_sql_mode = @@sql_mode ;
set sql_mode='';
CREATE TABLE t_date (c1 DATE, c2 TIME, c3 TIMESTAMP, c4 DATETIME, c5 YEAR);
INSERT INTO t_date VALUES ('2015-07-23', '16:34:12', '2015-07-23 16:34:12', '2015-07-23 16:34:12', '2015');
INSERT INTO t_date VALUES ('0-1-1', '-1:0:0.12', '2000-1-1 0:0:2', '0-1-1', '1999');
INSERT INTO t_date VALUES (NULL, NULL, NULL, NULL, NULL);
INSERT INTO t_date VALUES ('0000-00-00', '00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0);
SET @@sql_mode = @SAVE_sql_mode ;

#
# BINARY
#
CREATE TABLE t_lob (c1  TINYBLOB,
                    c2  BLOB,
                    c3  MEDIUMBLOB,
                    c4  LONGBLOB,
                    c5  TINYTEXT,
                    c6  TEXT,
                    c7  MEDIUMTEXT,
                    c8  LONGTEXT,
                    c9  TINYTEXT BINARY,
                    c10 TEXT BINARY,
                    c11 MEDIUMTEXT BINARY,
                    c12 LONGTEXT BINARY);

INSERT INTO t_lob  VALUES ('','','','','','','','','','','','');
INSERT INTO t_lob  VALUES ('tinyblob-text readable','blob-text readable','mediumblob-text readable',
                           'longblob-text readable','tinytext','text','mediumtext','longtext',
                           'tinytext-binary\nnext line','text-binary\nnext line',
                           'mediumtext-binary\nnext line','longtext-binary \nnext line');
INSERT INTO t_lob  VALUES (NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);

#
# STRING
#
CREATE TABLE t_char (c1 CHAR(32),
                     c2 VARCHAR(32),
                     c3 BINARY(32),
                     c4 VARBINARY(32),
                     c5 VARCHAR(32) COLLATE 'latin1_swedish_ci'
                   ) CHARACTER SET 'utf8mb4';
INSERT INTO t_char VALUES ('char', 'varchar', 'binary', 'varbinary', 'accent');
INSERT INTO t_char VALUES ('chár™€', 'varchár™€', 'bínary™€', 'varbínary™€', 'bíñáry'); -- server converts from utf8 to latin1
INSERT INTO t_char VALUES ('chár™€', 'varchár™€', 'bínary™€', 'varbínary™€', _latin1 0x62EDF1E17279); -- 'bíñáry' as latin1 literal
INSERT INTO t_char VALUES ('⚽️', '🏀', '🏈', '⚾️', '');
INSERT INTO t_char VALUES ('', '', '', '', '');
INSERT INTO t_char VALUES (NULL, NULL, NULL, NULL, NULL);

CREATE TABLE t_lchar (c1 CHAR(32),
                      c2 VARCHAR(32),
                      c3 BINARY(32),
                      c4 VARBINARY(32)
                    ) CHARACTER SET 'latin1';
INSERT INTO t_lchar VALUES ('char', 'varchar', 'binary', 'varbinary');
INSERT INTO t_lchar VALUES ('çhár', 'varçhár', 'çínary', 'çarbínary');
INSERT INTO t_lchar VALUES (NULL, NULL, NULL, NULL);

#
# OTHER
#
CREATE TABLE t_bit (c1 BIT(1), c2 BIT(64));
INSERT INTO t_bit  VALUES (b'0', b'0');
INSERT INTO t_bit  VALUES (b'1', b'1');
INSERT INTO t_bit  VALUES (b'1', b'1111111111111111111111111111111111111111111111111111111111111111');
INSERT INTO t_bit  VALUES (b'1', b'0101010101010101010101010101010101010101010101010101010101010101');
INSERT INTO t_bit  VALUES (NULL, NULL);

CREATE TABLE t_enum (c1 ENUM('v1','v2','v3'), c2 ENUM(''));
INSERT INTO t_enum  VALUES ('v1', '');
INSERT INTO t_enum  VALUES ('v2', '');
INSERT INTO t_enum  VALUES (NULL, NULL);

CREATE TABLE t_set (c1 SET('v1','v2','v3'), c2 SET(''));
INSERT INTO t_set  VALUES ('v1,v1,v2', '');
INSERT INTO t_set  VALUES ('', '');
INSERT INTO t_set  VALUES (NULL, NULL);

/*!50708 CREATE TABLE t_json (jdoc JSON) */;
/*!50708 INSERT INTO t_json VALUES('{"char": "varchar", "binary": "varbinary"}') */;
/*!50708 INSERT INTO t_json VALUES('{"çhár": "varçhár", "çínary": "çarbínary"}') */;
/*!50708 INSERT INTO t_json VALUES('["abc", 10, null, true, false]') */;

CREATE TABLE t_geom (g GEOMETRY);
INSERT INTO t_geom VALUES (ST_GeomFromText('POINT(1 1)'));
INSERT INTO t_geom VALUES (ST_GeomFromText('LINESTRING(0 0,1 1,2 2)'));
INSERT INTO t_geom VALUES (ST_GeomFromText('POLYGON((0 0,10 0,10 10,0 10,0 0),(5 5,7 5,7 7,5 7, 5 5))'));
INSERT INTO t_geom VALUES (ST_GeomFromText('GEOMETRYCOLLECTION(POINT(1 1),LINESTRING(0 0,1 1,2 2,3 3,4 4))'));

CREATE TABLE t_geom_all (g GEOMETRY, p POINT, l LINESTRING, pl POLYGON, mp MULTIPOINT, ml MULTILINESTRING, mpl MULTIPOLYGON, gc GEOMETRYCOLLECTION);
INSERT INTO t_geom_all VALUES (ST_GeomFromText('POINT(145124232345 15452323452345)'),
  ST_GeomFromText('POINT(-431.4312 645.756786)'),
  ST_GeomFromText('LINESTRING(5342 5675678,2341.423 7564.789,-2341.2341 7456.756786,1234.1234 -5674.56788)'),
  ST_GeomFromText('POLYGON((5234.2345 64573.5634,1423.1234 6345.3456,4123.1234 4123.1234,3456.5634 5674.6745,52345234.255 134342.33,5234.2345 64573.5634),(5634.345636 56442313.7856678,4123.2341 4567.4567,67855786.5634 23452345.675,23455234.4523 6457455.5346,4523.2345 34522345.21,5634.345636 56442313.7856678))'),
  ST_GeomFromText('MULTIPOINT((4541233412.134314 56343456.56345634),(53425234.23453452 56435634.23454523),(-43231234.45 -552342345.534))'),
  ST_GeomFromText('MULTILINESTRING((5342 5675678,2341.423 7564.789,-2341.2341 7456.756786,1234.1234 -5674.56788),(5342 5675678,2341.423 7564.789,-2341.2341 7456.756786,1234.1234 -5674.56788))'),
  ST_GeomFromText('MULTIPOLYGON(((5234.2345 64573.5634,1423.1234 6345.3456, 4123.1234 4123.1234,3456.5634 5674.6745,5234.2345 64573.5634),(5634.345636 56442313.7856678,4123.2341 4567.4567,67855786.5634 23452345.675,23455234.4523 645745636345.5346,4523.2345 34522345.21,5634.345636 56442313.7856678)))'),
  ST_GeomFromText('GEOMETRYCOLLECTION(GEOMETRYCOLLECTION(LINESTRING(0 0, 1 1)),LINESTRING(2 2, 3 3))'));
