
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileBoundariesAttributes.h
    \brief Definition of Boundaries Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef BoundariesAttributes_H
#define BoundariesAttributes_H

#include "magics.h"
#include "Colour.h"
namespace magics {

class XmlNode;
class BoundariesAttributes 
{
public:
//  --  constructor
    BoundariesAttributes();
    
//  --  destructor
    virtual ~BoundariesAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const BoundariesAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	int thickness_;
	bool disputed_;
	int disputed_thickness_;
	bool admistrative_;
	stringarray administrative_list_;
	int administrative_thickness_;
	LineStyle style_;
	unique_ptr<Colour> colour_;
	LineStyle disputed_style_;
	unique_ptr<Colour> disputed_colour_;
	LineStyle administrative_style_;
	unique_ptr<Colour> administrative_colour_;
	 

private:
	friend ostream& operator<<(ostream& s,const BoundariesAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

